/********************************************
; File: GSOS.h
;
;
; Copyright Apple Computer, Inc.1986-90
; All Rights Reserved
;
********************************************/
#ifndef __TYPES__
#include <TYPES.h>
#endif

#ifndef __GSOS__
#define __GSOS__


/*
    Read/Write enable bit Codes
    for CreateRec/OpenRec access and requestAccess fields
*/

#define readEnableAllowWrite 0x0000
#define readEnable 0x0001
#define writeEnable 0x0002
#define readWriteEnable 0x0003
#define fileInvisible 0x0004  /* Invisible bit */
#define backupNeeded 0x0020  /* backup needed bit: CreateRec/ OpenRec access  field. (Must be 0 in requestAccess field ) */
#define renameEnable 0x0040  /* rename enable bit: CreateRec/ OpenRec access and requestAccess fields */
#define destroyEnable 0x0080  /* destroy enable  bit: CreateRec/ OpenRec access and requestAccess fields */
#define startPlus 0x0000  /* base -> setMark = displacement */
#define eofMinus 0x0001  /* base -> setMark = eof - displacement */
#define markPlus 0x0002  /* base -> setMark = mark + displacement */
#define markMinus 0x0003  /* base -> setMark = mark - displacement */

/* cachePriority Codes */
#define cacheOff 0x0000  /* do not cache blocks invloved in this read */
#define cacheOn 0x0001  /* cache blocks invloved in this read if possible */

/* Error Codes */
#define badSystemCall 0x0001  /* bad system call number */
#define invalidPcount 0x0004  /* invalid parameter count */
#define gsosActive 0x0007  /* GS/OS already active */
#ifndef devNotFound  /* device not found */
#define devNotFound 0x10
#endif
#define invalidDevNum 0x11  /* invalid device number */
#define drvrBadReq 0x20  /* bad request or command */
#define drvrBadCode 0x0021  /* bad control or status code */
#define drvrBadParm 0x0022  /* bad call parameter */
#define drvrNotOpen 0x0023  /* character device not open */
#define drvrPriorOpen 0x0024  /* character device already open */
#define irqTableFull 0x0025  /* interrupt table full */
#define drvrNoResrc 0x0026  /* resources not available */
#define drvrIOError 0x0027  /* I/O error */
#define drvrNoDevice 0x0028  /* device not connected */
#define drvrBusy 0x0029  /* call aborted; driver is busy */
#define drvrWrtProt 0x002B  /* device is write protected */
#define drvrBadCount 0x002C  /* invalid byte count */
#define drvrBadBlock 0x002D  /* invalid block address */
#define drvrDiskSwitch 0x002E  /* disk has been switched */
#define drvrOffLine 0x002F  /* device off line/ no media present */
#define badPathSyntax 0x0040  /* invalid pathname syntax */
#define invalidRefNum 0x0043  /* invalid reference number */
#ifndef pathNotFound  /* subdirectory does not exist */
#define pathNotFound 0x44
#endif
#define volNotFound 0x0045  /* volume not found */
#ifndef fileNotFound  /* file not found */
#define fileNotFound 0x0046
#endif
#define dupPathname 0x0047  /* create or rename with existing name */
#define volumeFull 0x0048  /* volume full error */
#define volDirFull 0x0049  /* volume directory full */
#define badFileFormat 0x004A  /* version error (incompatible file format) */
#ifndef badStoreType  /* unsupported (or incorrect) storage type */
#define badStoreType 0x004B
#endif
#ifndef eofEncountered  /* end-of-file encountered */
#define eofEncountered 0x004C
#endif
#define outOfRange 0x004D  /* position out of range */
#define invalidAccess 0x004E  /* access not allowed */
#define buffTooSmall 0x004F  /* buffer too small */
#define fileBusy 0x0050  /* file is already open */
#define dirError 0x0051  /* directory error */
#define unknownVol 0x0052  /* unknown volume type */
#ifndef paramRangeErr  /* parameter out of range */
#define paramRangeErr 0x0053
#endif
#define outOfMem 0x0054  /* out of memory */
#define dupVolume 0x0057  /* duplicate volume name */
#define notBlockDev 0x0058  /* not a block device */
#ifndef invalidLevel  /* specifield level outside legal range */
#define invalidLevel 0x0059
#endif
#define damagedBitMap 0x005A  /* block number too large */
#define badPathNames 0x005B  /* invalid pathnames for ChangePath */
#define notSystemFile 0x005C  /* not an executable file */
#define osUnsupported 0x005D  /* Operating System not supported */
#ifndef stackOverflow  /* too many applications on stack */
#define stackOverflow 0x005F
#endif
#define dataUnavail 0x0060  /* Data unavailable */
#define endOfDir 0x0061  /* end of directory has been reached */
#define invalidClass 0x0062  /* invalid FST call class */
#define resForkNotFound 0x0063  /* file does not contain required resource */
#define invalidFSTID 0x0064  /* error - FST ID is invalid */
#define devNameErr 0x0067  /* device exists with same name as replacement name */
#define resExistsErr 0x0070  /* cannot expand file, resource already exists */
#define resAddErr 0x0071  /* cannot add resource fork to this type file */

/* fileSys IDs */
#define proDOSFSID 0x0001  /* ProDOS/SOS  */
#define dos33FSID 0x0002  /* DOS 3.3 */
#define dos32FSID 0x0003  /* DOS 3.2 */
#define dos31FSID 0x0003  /* DOS 3.1 */
#define appleIIPascalFSID 0x0004  /* Apple II Pascal */
#define mfsFSID 0x0005  /* Macintosh (flat file system) */
#define hfsFSID 0x0006  /* Macintosh (hierarchical file system) */
#define lisaFSID 0x0007  /* Lisa file system */
#define appleCPMFSID 0x0008  /* Apple CP/M */
#define charFSTFSID 0x0009  /* Character FST */
#define msDOSFSID 0x000A  /* MS/DOS */
#define highSierraFSID 0x000B  /* High Sierra */
#define iso9660FSID 0x000C  /* ISO 9660 */
#define appleShareFSID 0x000D  /* ISO 9660 */

/* FSTInfo.attributes Codes */
#define characterFST 0x4000  /* character FST */
#define ucFST 0x8000  /* SCM should upper case pathnames before passing them to the FST */

/* QuitRec.flags Codes */
#define onStack 0x8000  /* place state information about quitting program on the quit return stack */
#define restartable 0x4000  /* the quitting program is capable of being restarted from its dormant memory */

/* storageType Codes */
#define seedling 0x0001  /* standard file with seedling structure */
#define standardFile 0x0001  /* standard file type (no resource fork) */
#define sapling 0x0002  /* standard file with sapling structure */
#define tree 0x0003  /* standard file with tree structure */
#define pascalRegion 0x0004  /* UCSD Pascal region on a partitioned disk */
#define extendedFile 0x0005  /* extended file type (with resource fork) */
#define directoryFile 0x000D  /* volume directory or subdirectory file */

/* version Codes */
#define minorRelNumMask 0x00FF  /* minor release number */
#define majorRelNumMask 0x7F00  /* major release number */
#define finalRelNumMask 0x8000  /* final release number */

/* Other Constants */
#define isFileExtended 0x8000  /* GetDirEntryGS */

/* DControl Codes */
#define resetDevice 0x0000
#define formatDevice 0x0001
#define eject 0x0002
#define setConfigParameters 0x0003
#define setWaitStatus 0x0004
#define setFormatOptions 0x0005
#define assignPartitionOwner 0x0006
#define armSignal 0x0007
#define disarmSignal 0x0008
#define setPartitionMap 0x0009
struct GSString255 {
   Word length; /* Number of Chars in text field  */
   char text[255]; /*  */
} ;
typedef struct GSString255 GSString255, *GSString255Ptr, **GSString255Hndl;
typedef GSString255Hndl *GSString255HndlPtr;
struct GSString32 {
   Word length; /* Number of characters in text field */
   char text[32]; /*  */
} ;
typedef struct GSString32 GSString32, *GSString32Ptr, **GSString32Hndl;
struct ResultBuf255 {
   Word bufSize; /*  */
   GSString255 bufString; /*  */
} ;
typedef struct ResultBuf255 ResultBuf255, *ResultBuf255Ptr, **ResultBuf255Hndl;
typedef ResultBuf255Hndl *ResultBuf255HndlPtr ;



struct ResultBuf32 {
   Word bufSize; /*  */
   GSString32 bufString; /*  */
} ;
typedef struct ResultBuf32 ResultBuf32, *ResultBuf32Ptr, **ResultBuf32Hndl;
struct ChangePathRecGS {
   Word pCount; /*  */
   GSString255Ptr pathname; /*  */
   GSString255Ptr newPathname; /*  */
} ;
typedef struct ChangePathRecGS ChangePathRecGS, *ChangePathRecPtrGS;
struct CreateRecGS {
   Word pCount; /*  */
   GSString255Ptr pathname; /*  */
   Word access; /*  */
   Word fileType; /*  */
   LongWord auxType; /*  */
   Word storageType; /*  */
   LongWord eof; /*  */
   LongWord resourceEOF; /*  */
} ;
typedef struct CreateRecGS CreateRecGS, *CreateRecPtrGS;
struct DAccessRecGS {
   Word pCount; /*  */
   Word devNum; /*  */
   Word code; /*  */
   Pointer list; /*  */
   LongWord requestCount; /*  */
   LongWord transferCount; /*  */
} ;
typedef struct DAccessRecGS DAccessRecGS, *DAccessRecPtrGS;
struct DevNumRecGS {
   Word pCount;
   GSString32Ptr devName;
   Word devNum;
} ;
typedef struct DevNumRecGS DevNumRecGS, *DevNumRecPtrGS;
struct DInfoRecGS {
   Word pCount; /* minimum = 2 */
   Word devNum;
   ResultBuf32Ptr devName;
   Word characteristics;
   LongWord totalBlocks;
   Word slotNum;
   Word unitNum;
   Word version;
   Word deviceID;
   Word headLink;
   Word forwardLink;
   Pointer extendedDIBPtr;
} ;
typedef struct DInfoRecGS DInfoRecGS, *DInfoRecPtrGS;
struct DIORecGS {
   Word pCount; /*  */
   Word devNum; /*  */
   Pointer buffer; /*  */
   LongWord requestCount; /*  */
   LongWord startingBlock; /*  */
   Word blockSize; /*  */
   LongWord transferCount; /*  */
} ;
typedef struct DIORecGS DIORecGS, *DIORecPtrGS;
struct DirEntryRecGS {
   Word pCount;
   Word refNum;
   Word flags;
   Word base;
   Word displacement;
   ResultBuf255Ptr name;
   Word entryNum;
   Word fileType;
   Longint eof;
   LongWord blockCount;
   TimeRec createDateTime;
   TimeRec modDateTime;
   Word access;
   LongWord auxType;
   Word fileSysID;
   ResultBuf255Ptr optionList;
   LongWord resourceEOF;
   LongWord resourceBlocks;
} ;
typedef struct DirEntryRecGS DirEntryRecGS, *DirEntryRecPtrGS;
struct DRenameRecGS {
   Word pCount;
   Word devNum;
   GSString32Ptr strPtr;
} ;
typedef struct DRenameRecGS DRenameRecGS, *DRenameRecGSPtr;
struct ExpandPathRecGS {
   Word pCount;
   GSString255Ptr inputPath;
   ResultBuf255Ptr outputPath;
   Word flags;
} ;
typedef struct ExpandPathRecGS ExpandPathRecGS, *ExpandPathRecPtrGS;
struct FileInfoRecGS {
   Word pCount;
   GSString255Ptr pathname;
   Word access;
   Word fileType;
   LongWord auxType;
   Word storageType; /* must be 0 for SetFileInfo */
   TimeRec createDateTime;
   TimeRec modDateTime;
   ResultBuf255Ptr optionList;
   LongWord eof;
   LongWord blocksUsed; /* must be 0 for SetFileInfo */
   LongWord resourceEOF; /* must be 0 for SetFileInfo */
   LongWord resourceBlocks; /* must be 0 for SetFileInfo */
} ;
typedef struct FileInfoRecGS FileInfoRecGS, *FileInfoRecPtrGS;
struct FormatRecGS {
   Word pCount; /*  */
   GSString32Ptr devName; /* device name pointer */
   GSString32Ptr volName; /* volume name pointer */
   Word fileSysID; /* file system ID */
   Word reqFileSysID; /* in;  */
} ;
typedef struct FormatRecGS FormatRecGS, *FormatRecPtrGS;
struct FSTInfoRecGS {
   Word pCount; /*  */
   Word fstNum; /*  */
   Word fileSysID; /*  */
   ResultBuf255Ptr fstName; /*  */
   Word version; /*  */
   Word attributes; /*  */
   Word blockSize; /*  */
   LongWord maxVolSize; /*  */
   LongWord maxFileSize; /*  */
} ;
typedef struct FSTInfoRecGS FSTInfoRecGS, *FSTInfoRecPtrGS;
struct InterruptRecGS {
   Word pCount;
   Word intNum;
   Word vrn; /* used only by BindInt */
   ProcPtr intCode; /* used only by BindInt */
} ;
typedef struct InterruptRecGS InterruptRecGS, *InterruptRecPtrGS;
struct IORecGS {
   Word pCount; /*  */
   Word refNum; /*  */
   Pointer dataBuffer; /*  */
   LongWord requestCount; /*  */
   LongWord transferCount; /*  */
   Word cachePriority; /*  */
} ;
typedef struct IORecGS IORecGS, *IORecPtrGS;
struct LevelRecGS {
   Word pCount; /*  */
   Word level; /*  */
} ;
typedef struct LevelRecGS LevelRecGS, *LevelRecPtrGS;
struct NameRecGS {
   Word pCount; /*  */
   GSString255Ptr pathname; /* full pathname or a filename depending on call */
} ;
typedef struct NameRecGS NameRecGS, *NameRecPtrGS;
struct NotifyProcRecGS {
   Word pCount; /*   */
   ProcPtr procPointer; /*   */
} ;
typedef struct NotifyProcRecGS NotifyProcRecGS, *NotifyProcRecGSPtr;
struct GetNameRecGS {
   Word pCount;
   ResultBuf255Ptr dataBuffer; /* full pathname or a filename depending on call */
} ;
typedef struct GetNameRecGS GetNameRecGS, *GetNameRecPtrGS;
struct NewlineRecGS {
   Word pCount; /*  */
   Word refNum; /*  */
   Word enableMask; /*  */
   Word numChars; /*  */
   Pointer newlineTable; /*  */
} ;
typedef struct NewlineRecGS NewlineRecGS, *NewlineRecPtrGS;
struct OpenRecGS {
   Word pCount;
   Word refNum;
   GSString255Ptr pathname;
   Word requestAccess;
   Word resourceNumber; /* For extended files: dataFork/resourceFork */
   Word access; /* Value of file's access attribute */
   Word fileType; /* Value of file's fileType attribute */
   LongWord auxType;
   Word storageType;
   TimeRec createDateTime;
   TimeRec modDateTime;
   ResultBuf255Ptr optionList;
   LongWord eof;
   LongWord blocksUsed;
   LongWord resourceEOF;
   LongWord resourceBlocks;
} ;
typedef struct OpenRecGS OpenRecGS, *OpenRecPtrGS;
struct OSShutDownRecGS {
   Word pCount;
   Word shutdownFlag;
} ;
typedef struct OSShutDownRecGS OSShutDownRecGS, *OSShutDownRecPtrGS;
struct PositionRecGS {
   Word pCount; /*  */
   Word refNum; /*  */
   LongWord position; /*  */
} ;
typedef struct PositionRecGS PositionRecGS, *PositionRecPtrGS;
struct EOFRecGS {
   Word pCount; /*  */
   Word refNum; /*  */
   LongWord eof; /*  */
} ;
typedef struct EOFRecGS EOFRecGS, *EOFRecPtrGS;

typedef struct PrefixRecGS {
   Word pCount; /*  */
   Word prefixNum; /*  */
   union {
     ResultBuf255Ptr getPrefix; /*  */
     GSString255Ptr setPrefix; /*  */
   } buffer;
   } PrefixRecGS, *PrefixRecPtrGS;
struct QuitRecGS {
   Word pCount; /*  */
   GSString255Ptr pathname; /* pathname of next app to run */
   Word flags; /*  */
} ;
typedef struct QuitRecGS QuitRecGS, *QuitRecPtrGS;
struct RefNumRecGS {
   Word pCount;
   Word refNum;
} ;
typedef struct RefNumRecGS RefNumRecGS, *RefnumRecPtrGS;
struct GetRefNumRecGS {
   Word pCount;
   GSString255Ptr pathname;
   Word refNum;
   Word access;
   Word resNum;
   Boolean caseSense;
   Word displacement;
} ;
typedef struct GetRefNumRecGS GetRefNumRecGS, *GetRefNumRecPtrGS;
struct StdRefNumRecGS {
   Word pCount; /*   */
   Word prefixNum; /*   */
   Word refNum; /*   */
} ;
typedef struct StdRefNumRecGS StdRefNumRecGS, *StdRefNumRecGSPtr;
struct SessionStatusRecGS {
   Word pCount; /* in: min = 1 */
   Word status; /* out: */
} ;
typedef struct SessionStatusRecGS SessionStatusRecGS, *SessionStatusRecPtrGS;
struct SetPositionRecGS {
   Word pCount; /*  */
   Word refNum; /*  */
   Word base; /*  */
   LongWord displacement; /*  */
} ;
typedef struct SetPositionRecGS SetPositionRecGS, *SetPositionRecPtrGS;
struct SysPrefsRecGS {
   Word pCount; /*  */
   Word preferences; /*  */
} ;
typedef struct SysPrefsRecGS SysPrefsRecGS, *SysPrefsRecPtrGS;
struct VersionRecGS {
   Word pCount; /*  */
   Word version; /*  */
} ;
typedef struct VersionRecGS VersionRecGS, *VersionRecPtrGS;
struct VolumeRecGS {
   Word pCount; /*  */
   GSString32Ptr devName; /*  */
   ResultBuf255Ptr volName; /*  */
   LongWord totalBlocks; /*  */
   LongWord freeBlocks; /*  */
   Word fileSysID; /*  */
   Word blockSize; /*  */
} ;
typedef struct VolumeRecGS VolumeRecGS, *VolumeRecPtrGS;
struct RefInfoRecGS {
   Word pCount; /*   */
   Word refNum; /*   */
   Word access; /*   */
   ResultBuf255Ptr pathname; /*   */
} ;
typedef struct RefInfoRecGS RefInfoRecGS, *RefInfoRecGSPtr;
#ifndef stackEntry
#define stackEntry 0xE100B0
#endif
#ifndef sysCall
extern pascal void sysCall() inline(0x0000,stackEntry); 
#endif

#define AddNotifyProcGS(pBlockPtr)  sysCall(pBlockPtr,0x2034)
#define BeginSessionGS(pBlockPtr)  sysCall(pBlockPtr,0x201D)
#define BindIntGS(pBlockPtr)  sysCall(pBlockPtr,0x2031)
#define ChangePathGS(pBlockPtr)  sysCall(pBlockPtr,0x2004)
#define ClearBackupBitGS(pBlockPtr)  sysCall(pBlockPtr,0x200B)
#define CloseGS(pBlockPtr)  sysCall(pBlockPtr,0x2014)
#define CreateGS(pBlockPtr)  sysCall(pBlockPtr,0x2001)
#define DControlGS(pBlockPtr)  sysCall(pBlockPtr,0x202E)
#define DelNotifyProcGS(pBlockPtr)  sysCall(pBlockPtr,0x2035)
#define DestroyGS(pBlockPtr)  sysCall(pBlockPtr,0x2002)
#define DInfoGS(pBlockPtr)  sysCall(pBlockPtr,0x202C)
#define DReadGS(pBlockPtr)  sysCall(pBlockPtr,0x202F)
#define DRenameGS(pBlockPtr)  sysCall(pBlockPtr,0x2036)
#define DStatusGS(pBlockPtr)  sysCall(pBlockPtr,0x202D)
#define DWriteGS(pBlockPtr)  sysCall(pBlockPtr,0x2030)
#define EndSessionGS(pBlockPtr)  sysCall(pBlockPtr,0x201E)
#define EraseDiskGS(pBlockPtr)  sysCall(pBlockPtr,0x2025)
#define ExpandPathGS(pBlockPtr)  sysCall(pBlockPtr,0x200E)
#define FlushGS(pBlockPtr)  sysCall(pBlockPtr,0x2015)
#define FormatGS(pBlockPtr)  sysCall(pBlockPtr,0x2024)
#define FSTSpecific(pBlockPtr)  sysCall(pBlockPtr,0x2033)
#define GetBootVolGS(pBlockPtr)  sysCall(pBlockPtr,0x2028)
#define GetDevNumberGS(pBlockPtr)  sysCall(pBlockPtr,0x2020)
#define GetDirEntryGS(pBlockPtr)  sysCall(pBlockPtr,0x201C)
#define GetEOFGS(pBlockPtr)  sysCall(pBlockPtr,0x2019)
#define GetFileInfoGS(pBlockPtr)  sysCall(pBlockPtr,0x2006)
#define GetFSTInfoGS(pBlockPtr)  sysCall(pBlockPtr,0x202B)
#define GetLevelGS(pBlockPtr)  sysCall(pBlockPtr,0x201B)
#define GetMarkGS(pBlockPtr)  sysCall(pBlockPtr,0x2017)
#define GetNameGS(pBlockPtr)  sysCall(pBlockPtr,0x2027)
#define GetPrefixGS(pBlockPtr)  sysCall(pBlockPtr,0x200A)
#define GetRefInfoGS(pBlockPtr)  sysCall(pBlockPtr,0x2039)
#define GetRefNumGS(pBlockPtr)  sysCall(pBlockPtr,0x2038)
#define GetStdRefNumGS(pBlockPtr)  sysCall(pBlockPtr,0x2037)
#define GetSysPrefsGS(pBlockPtr)  sysCall(pBlockPtr,0x200F)
#define GetVersionGS(pBlockPtr)  sysCall(pBlockPtr,0x202A)
#define NewlineGS(pBlockPtr)  sysCall(pBlockPtr,0x2011)
#define NullGS(pBlockPtr)  sysCall(pBlockPtr,0x200D)
#define OpenGS(pBlockPtr)  sysCall(pBlockPtr,0x2010)
#define OSShutDownGS(pBlockPtr)  sysCall(pBlockPtr,0x2003)
#define QuitGS(pBlockPtr)  sysCall(pBlockPtr,0x2029)
#define ReadGS(pBlockPtr)  sysCall(pBlockPtr,0x2012)
#define ResetCacheGS(pBlockPtr)  sysCall(pBlockPtr,0x2026)
#define SessionStatusGS(pBlockPtr)  sysCall(pBlockPtr,0x201F)
#define SetEOFGS(pBlockPtr)  sysCall(pBlockPtr,0x2018)
#define SetFileInfoGS(pBlockPtr)  sysCall(pBlockPtr,0x2005)
#define SetLevelGS(pBlockPtr)  sysCall(pBlockPtr,0x201A)
#define SetMarkGS(pBlockPtr)  sysCall(pBlockPtr,0x2016)
#define SetPrefixGS(pBlockPtr)  sysCall(pBlockPtr,0x2009)
#define SetSysPrefsGS(pBlockPtr)  sysCall(pBlockPtr,0x200C)
#define UnbindIntGS(pBlockPtr)  sysCall(pBlockPtr,0x2032)
#define VolumeGS(pBlockPtr)  sysCall(pBlockPtr,0x2008)
#define WriteGS(pBlockPtr)  sysCall(pBlockPtr,0x2013)
#ifndef __PRODOS__ 
 
#define GetSysPrefs(arg)  GetSysPrefsGS(arg)
#define BeginSession(arg)  BeginSessionGS(arg)
#define EndSession(arg)  EndSessionGS(arg)
#define SessionStatus(arg)  SessionStatusGS(arg)
#define ResetCache(arg)  ResetCacheGS(arg)
#define ChangePath(arg)  ChangePathGS(arg)
#define ClearBackupBit(arg)  ClearBackupBitGS(arg)
#define Close(arg)  CloseGS(arg)
#define Create(arg)  CreateGS(arg)
#define DControl(arg)  DControlGS(arg)
#define Destroy(arg)  DestroyGS(arg)
#define DInfo(arg)  DInfoGS(arg)
#define DRead(arg)  DReadGS(arg)
#define DStatus(arg)  DStatusGS(arg)
#define DWrite(arg)  DWriteGS(arg)
#define EraseDisk(arg)  EraseDiskGS(arg)
#define ExpandPath(arg)  ExpandPathGS(arg)
#define Flush(arg)  FlushGS(arg)
#define Format(arg)  FormatGS(arg)
#define GetBootVol(arg)  GetBootVolGS(arg)
#define GetDevNumber(arg)  GetDevNumberGS(arg)
#define GetDirEntry(arg)  GetDirEntryGS(arg)
#define GetEOF(arg)  GetEOFGS(arg)
#define GetFileInfo(arg)  GetFileInfoGS(arg) 
#define GetFSTInfo(arg)  GetFSTInfoGS(arg)
#define GetLevel(arg)  GetLevelGS(arg)
#define GetMark(arg)  GetMarkGS(arg)
#define GetName(arg)  GetNameGS(arg)
#define GetPrefix(arg)  GetPrefixGS(arg)
#define GetVersion(arg)  GetVersionGS(arg)
#define Newline(arg)  NewlineGS(arg)
#define Null(arg)  NullGS(arg)
#define Open(arg)  OpenGS(arg)
#define Quit(arg)  QuitGS(arg)
#define Read(arg)  ReadGS(arg)
#define SetEOF(arg)  SetEOFGS(arg)
#define SetFileInfo(arg)  SetFileInfoGS(arg)
#define SetLevel(arg)  SetLevelGS(arg)
#define SetMark(arg)  SetMarkGS(arg)
#define SetPrefix(arg)  SetPrefixGS(arg)
#define UnbindInt(arg)  UnbindIntGS(arg)
#define Volume(arg)  VolumeGS(arg)
#define Write(arg)  WriteGS(arg)
#define BindInt(arg)  BindIntGS(arg)
 
#define ChangePathRec ChangePathRecGS 
#define CreateRec CreateRecGS 
#define DAccessRec DAccessRecGS 
#define DevNumRec DevNumRecGS 
#define DInfoRec DInfoRecGS 
#define DIORec DIORecGS 
#define DirEntryRec DirEntryRecGS 
#define EOFRec EOFRecGS
#define ExpandPathRec ExpandPathRecGS 
#define FileInfoRec FileInfoRecGS 
#define FormatRec FormatRecGS 
#define FSTInfoRec FSTInfoRecGS 
#define InterruptRec InterruptRecGS 
#define IORec IORecGS 
#define LevelRec LevelRecGS 
#define NameRec NameRecGS
#define GetNameRec GetNameRecGS 
#define NewlineRec NewlineRecGS 
#define OpenRec OpenRecGS 
#define PositionRec PositionRecGS 
#define PrefixRec PrefixRecGS 
#define QuitRec QuitRecGS 
#define RefNumRec RefNumRecGS 
#define SetPositionRec SetPositionRecGS 
#define SysPrefRec SysPrefRecGS 
#define VersionRec VersionRecGS 
#define VolumeRec VolumeRecGS 
 
#endif 


#endif
